

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
inline	float& RigidBody::Tofi()	{ return mTofi; }



//////////////////////////////////////////////////////////////////
/// Returns the Transform Mtx.  
//////////////////////////////////////////////////////////////////
const VuMtx& RigidBody::GetTransform()
{
	return Transform;
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
NUQUAT RigidBody::GetRotation()
{
	if (GetRigidMass() ) 
	{
		return GetRigidMass()->GetRotation();
	}
	else
	{
		NUQUAT Q;
		NuMtxToQuat( &GetTransform().m, &Q );
		return Q;
	}
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
VuVec RigidBody::GetCentreOfMass()
{
	if (GetRigidMass()) return GetRigidMass()->GetCentreOfMass();
	else				return GetTransform()[3];
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
const VuVec& RigidBody::GetPosition()
{
	return Transform[3];
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
bool  RigidBody::IsKinematic() const				
{ 
	return TestFlag( ISKINEMATIC );
	//return mMotionType == KINEMATIC; 
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void RigidBody::SetKinematic( bool KF )
{
	bool Changed = (KF != TestFlag(ISKINEMATIC));

	//mMotionType = KF ? KINEMATIC : DYNAMIC;
	if (KF ) SetFlag( ISKINEMATIC );
	else	 ClearFlag( ISKINEMATIC );	

	NuAssert( KF || !ContainsKdTerrain() , "Can't make %s dynamic!", GetName() );

	if (Changed	)
		FlushLayerCache();

	Validate();
}

/*

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline SpecialObj* RigidBody::GetSpecial()					
{ 
	return MySpecial; 
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline void	RigidBody::SetSpecial( SpecialObj* Spec )  
{ 
	MySpecial = Spec; 
}

*/

///////////////////////////////////////////////////////////////////
/// Returns the rigid mass associated with this body.
///////////////////////////////////////////////////////////////////
RigidMass* RigidBody::GetRigidMass()   { return mRigidMass; }

///////////////////////////////////////////////////////////////////
/// Am i sleeping?  Bodies that are inactive for several frames are
/// deactivated and put to sleep.
///////////////////////////////////////////////////////////////////
short RigidBody::IsSleeping()		   { return TestFlag( SLEEPING ); }

////////////////////////////////////////////////////////////////////////
/// Returns true if this body isnt Kinematic AND doesnt have a rigidmass.
////////////////////////////////////////////////////////////////////////
inline bool RigidBody::IsStatic()					{ return mRigidMass==NULL;}
//inline bool	RigidBody::IsDynamic()					{ return MyRigidMass!=NULL && !TestFlag(ISKINEMATIC) ;}
inline bool	RigidBody::IsDynamic()					
{ 
	if (mRigidMass == NULL)
		return false;

	if (TestFlag(ISKINEMATIC))
		return false;

	return mRigidMass!=NULL;
}

//////////////////////////////////////////////////////////////////////////
//Raise, test or lower the flags.
//////////////////////////////////////////////////////////////////////////
bool  RigidBody::TestFlag( BodyFlags Flag ) const		
{	
	return (mBodyFlags & Flag) != 0;	
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
void RigidBody::ClearFlag( BodyFlags Flag )		
{	
	mBodyFlags = mBodyFlags & (BodyFlags) (~Flag);			
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
void RigidBody::SetFlags( BodyFlags flags ) 
{
	mBodyFlags = flags;			
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
void RigidBody::SetFlag( BodyFlags Flag )		
{	
	mBodyFlags  = mBodyFlags | Flag;			
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
RigidBody::BodyFlags RigidBody::GetFlags() const			
{	
	return (BodyFlags) mBodyFlags;			
}

